<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'downloads');
define('IN_VBDOWNLOADS', true);

if (isset($_REQUEST['do']) AND $_REQUEST['do'] == 'ajax')
{
	define('CSRF_PROTECTION', true);
	define('LOCATION_BYPASS', 1);
	define('NOPMPOPUP', 1);
	define('VB_ENTRY', 'ajax.php');
	define('SESSION_BYPASS', true);
	define('VB_ENTRY_TIME', microtime(true));
}

if (
	isset($_REQUEST['do']) AND isset($_REQUEST['action']) AND 
	$_REQUEST['do'] == 'download' AND $_REQUEST['action'] == 'modify'
)
{
	define('GET_EDIT_TEMPLATES', true);
}

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('dbtech_downloads', 'user', 'album', 'posting');

// get templates used by all actions
$globaltemplates = array(
	'dbtech_downloads',
	'dbtech_downloads_sidebar_bit'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'main' => array(
		'dbtech_downloads_home',
		'dbtech_downloads_categorybit',
		'dbtech_downloads_categorybit_subcategorybit',
		'dbtech_downloads_searchresults',
		'dbtech_downloads_searchresults_bit',
	),
	'search' => array(
		'dbtech_downloads_searchresults',
		'dbtech_downloads_searchresults_bit'
	),
	'download' => array(
		'dbtech_downloads_comment_bit',
		'dbtech_downloads_comment_wrapper',
		'dbtech_downloads_download',
		'dbtech_downloads_download_filebit',
		'dbtech_downloads_download_mirrorbit',
		'dbtech_downloads_download_morebit',
		'dbtech_downloads_download_password',
		'dbtech_downloads_download_screenshotbit',
		'dbtech_downloads_modify',
		'dbtech_downloads_modify_extensionbit',
	),
	'file' => array(
		'dbtech_downloads_delay'
	),
	'modcp' => array(
		'dbtech_downloads_modcp',
		'dbtech_downloads_modcp_report',
		'dbtech_downloads_modcp_moderation'
	),
	/*DBTECH_PRO_START*/
	'category' => array(
		'dbtech_downloads_category_list',
		'dbtech_downloads_category_list_bit',
		'dbtech_downloads_category_modify',
		'dbtech_downloads_category_modify_permissionbit',
	),
	'import' => array(
		'dbtech_downloads_import',
		'dbtech_downloads_import_filebit',
	),
	/*DBTECH_PRO_END*/	
);

// get special data templates from the datastore
require_once('./dbtech/downloads/includes/specialtemplates.php');
$specialtemplates = $extracache;
$specialtemplates[] = 'bbcodecache';

// ############################### default do value ######################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = $_GET['do'] = 'main';
}

if ($_REQUEST['do'] == 'upload' or $_REQUEST['do'] == 'editdownload')
{
	define('GET_EDIT_TEMPLATES', true);
	array_push($specialtemplates, 'smiliecache');
	array_push($specialtemplates, 'bbcodecache');
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/dbtech/downloads/includes/functions.php');

if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/downloads/includes/class_template.php');
}

if (!class_exists('VBDOWNLOADS'))
{
	eval(standard_error($vbphrase['dbtech_downloads_deactivated']));
}

if ($_REQUEST['do'] == 'devinfo' AND $_REQUEST['devkey'] == 'dbtech')
{
	VBDOWNLOADS::outputJSON(array(
		'version' 		=> VBDOWNLOADS::$version,
		'versionnumber' => VBDOWNLOADS::$versionnumber,
		'pro'			=> VBDOWNLOADS::$isPro,
		'vbversion'		=> $vbulletin->versionnumber
	));
}

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'main';
}

// Strip non-valid characters
$action = preg_replace('/[^\w-]/i', '', $action);

if (!$vbulletin->options['dbtech_downloads_online'] AND !VBDOWNLOADS::$permissions['ismanager'])
{
	// Sb is shut off
	eval(standard_error($vbulletin->options['dbtech_downloads_closedreason']));
}

if (!VBDOWNLOADS::$permissions['canview'])
{
	// Can't view downloads
	print_no_permission();
}

$_excludeCategories = array(0);
foreach (VBDOWNLOADS::$cache['category'] as $categoryid => $category)
{
	if (!is_array($category['permissions']['view']))
	{
		$category['permissions']['view'] = array();
	}
	$allowUgs = array();
	foreach ($category['permissions']['view'] as $usergroupid => $canview)
	{
		if ($canview)
		{
			// This UG can view this
			$allowUgs[] = $usergroupid;
		}
	}

	if (
		!count($allowUgs) OR 
		!is_member_of($vbulletin->userinfo, $allowUgs)/* OR (
			$category['ownerid'] AND 
			$category['ownerid'] != $vbulletin->userinfo['userid'] AND
			!VBDOWNLOADS::$permissions['ismanager']
		)*/
	)
	{
		// We can't access this category
		$_excludeCategories[] = $categoryid;
	}
}

$fileReportReasons = preg_split('#\r?\n#s', $vbulletin->options['dbtech_downloads_report_file_reasons'], -1, PREG_SPLIT_NO_EMPTY);
$commentReportReasons = preg_split('#\r?\n#s', $vbulletin->options['dbtech_downloads_report_comment_reasons'], -1, PREG_SPLIT_NO_EMPTY);
$linkReportReasons = preg_split('#\r?\n#s', $vbulletin->options['dbtech_downloads_report_mirror_reasons'], -1, PREG_SPLIT_NO_EMPTY);

// begin navbits
$navbits = array($vbulletin->options['dbtech_downloads_link'] . '.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['dbtech_downloads_downloads']);

// Core page template
$page_template = 'dbtech_downloads';

if (!file_exists(DIR . '/dbtech/downloads/actions/' . $action . '.php'))
{
	if (!file_exists(DIR . '/dbtech/downloads_pro/actions/' . $action . '.php'))
	{
		// Throw error from invalid action
		eval(standard_error(fetch_error('dbtech_downloads_error_x', $vbphrase['dbtech_downloads_invalid_action'])));
	}
	else
	{
		// Include the selected file
		include_once(DIR . '/dbtech/downloads_pro/actions/' . $action . '.php');	
	}
}
else
{
	// Include the selected file
	include_once(DIR . '/dbtech/downloads/actions/' . $action . '.php');	
}

if (intval($vbulletin->versionnumber) == 3)
{
	// Create navbits
	$navbits = construct_navbits($navbits);	
	eval('$navbar = "' . fetch_template('navbar') . '";');
}
else
{
	$navbar = render_navbar_template(construct_navbits($navbits));	
}

if (!$vbulletin->GPC['categoryid'])
{
	// Grab all child categories
	$categoryList = find_category_children($vbulletin->GPC['categoryid']);
}

$categories = array($vbulletin->GPC['categoryid'] => $vbulletin->GPC['categoryid']);
foreach ($categoryList as $category)
{
	// Add this to the list
	$categories[$category['categoryid']] = $category['categoryid'];
	
	if (count($category['children']))
	{
		// Construct the list of select options
		construct_category_select_options($categories, $category['children'], 0, false);
	}
}

$stats = array(
	'files' => (int)VBDOWNLOADS::$db->fetchOne('
		SELECT COUNT(*) FROM $dbtech_downloads_file
		INNER JOIN $dbtech_downloads_download AS download USING(downloadid)
		WHERE 1=1
		' . ($_REQUEST['categoryid'] ? '
			AND download.categoryid :categoryList
		' : '') . '
			AND download.categoryid NOT :queryList
			AND download.moderation = 0
	', array(
		':categoryList' => VBDOWNLOADS::$db->queryList(array_keys($categories)),
		':queryList' => VBDOWNLOADS::$db->queryList($_excludeCategories)
	)),
	'downloads' => (int)VBDOWNLOADS::$db->fetchOne('
		SELECT SUM(totaldownloads) FROM $dbtech_downloads_download AS download
		WHERE 1=1
		' . ($_REQUEST['categoryid'] ? '
			AND download.categoryid :categoryList
		' : '') . '
			AND download.categoryid NOT :queryList
			AND download.moderation = 0
	', array(
		':categoryList' => VBDOWNLOADS::$db->queryList(array_keys($categories)),
		':queryList' => VBDOWNLOADS::$db->queryList($_excludeCategories)
	))
);

$recentDownloads = VBDOWNLOADS::$db->fetchAll('
	SELECT * FROM $dbtech_downloads_download AS download
	WHERE 1=1
	' . ($_REQUEST['categoryid'] ? '
		AND download.categoryid :categoryList
	' : '') . '
		AND download.categoryid NOT :queryList
		AND download.moderation = 0
	ORDER BY updated DESC
	LIMIT 5
', array(
	':categoryList' => VBDOWNLOADS::$db->queryList(array_keys($categories)),
	':queryList' => VBDOWNLOADS::$db->queryList($_excludeCategories)
));

$topDownloads = VBDOWNLOADS::$db->fetchAll('
	SELECT * FROM $dbtech_downloads_download AS download
	WHERE 1=1
	' . ($_REQUEST['categoryid'] ? '
		AND download.categoryid :categoryList
	' : '') . '
		AND download.categoryid NOT :queryList
		AND download.moderation = 0
	ORDER BY totaldownloads DESC
	LIMIT 5
', array(
	':categoryList' => VBDOWNLOADS::$db->queryList(array_keys($categories)),
	':queryList' => VBDOWNLOADS::$db->queryList($_excludeCategories)
));

/*DBTECH_PRO_START*/
if ($vbulletin->options['dbtech_downloads_rate'])
{
	$highestDownloads = VBDOWNLOADS::$db->fetchAll('
		SELECT * FROM $dbtech_downloads_download AS download
		WHERE 1=1
		' . ($_REQUEST['categoryid'] ? '
			AND download.categoryid :categoryList
		' : '') . '
			AND download.categoryid NOT :queryList
			AND download.moderation = 0
		ORDER BY rating DESC
		LIMIT 5
	', array(
		':categoryList' => VBDOWNLOADS::$db->queryList(array_keys($categories)),
		':queryList' => VBDOWNLOADS::$db->queryList($_excludeCategories)
	));
}
/*DBTECH_PRO_END*/

$stats['recent'] = '';
foreach ($recentDownloads as $download)
{
	// No hacsors here please
	$download['title'] = htmlspecialchars_uni($download['title']);

	$download['date'] = vbdate($vbulletin->options['dateformat'], $download['updated'], true);
	$download['time'] = vbdate($vbulletin->options['timeformat'], $download['updated']);
	
	$download['value'] = $download['date'] . (!$show['detailedtime'] ? ', <span class="time">' . $download['time'] . '</span>' : '');

	$templater = vB_Template::create('dbtech_downloads_sidebar_bit');
		$templater->register('download', $download);
	$stats['recent'] .= $templater->render();
}

$stats['top'] = '';
foreach ($topDownloads as $download)
{
	// No hacsors here please
	$download['title'] = htmlspecialchars_uni($download['title']);

	$download['value'] = construct_phrase($vbphrase['dbtech_downloads_x_downloads'], '<span style="font-weight:bold;">' . vb_number_format($download['totaldownloads'], 0) . '</span>');
	
	$templater = vB_Template::create('dbtech_downloads_sidebar_bit');
		$templater->register('download', $download);
	$stats['top'] .= $templater->render();
}

/*DBTECH_PRO_START*/
if ($vbulletin->options['dbtech_downloads_rate'])
{
	$stats['highest'] = '';
	foreach ($highestDownloads as $download)
	{
		// No hacsors here please
		$download['title'] = htmlspecialchars_uni($download['title']);

		$download['value'] = construct_phrase($vbphrase['dbtech_downloads_rating_x'], '<span style="font-weight:bold;">' . vb_number_format($download['rating'], 0) . '</span>');
		
		$templater = vB_Template::create('dbtech_downloads_sidebar_bit');
			$templater->register('download', $download);
		$stats['highest'] .= $templater->render();
	}
}
/*DBTECH_PRO_END*/

$reportReasons = array('download' => '', 'comment' => '', 'link' => '');
foreach ($fileReportReasons as $index => $reason)
{
	$reportReasons['download'] .= '<label><input type="radio" name="reason" value="' . $index . '" /> ' . $reason . '</label><br /><br />';
}
foreach ($commentReportReasons as $index => $reason)
{
	$reportReasons['comment'] .= '<label><input type="radio" name="reason" value="' . $index . '" /> ' . $reason . '</label><br /><br />';
}
foreach ($linkReportReasons as $index => $reason)
{
	$reportReasons['link'] .= '<label><input type="radio" name="reason" value="' . $index . '" /> ' . $reason . '</label><br /><br />';
}

if (intval($vbulletin->versionnumber) == 3)
{
	// Begin the monster template
	$headinclude .= vB_Template::create('dbtech_downloads.css')->render();

	if ($_REQUEST['do'] == 'download' AND $_REQUEST['action'] == 'modify')
	{
		$headinclude .= vB_Template::create('dbtech_downloads_fileupload_ui.css')->render();
	}
}

// Finish the main template
$templater = vB_Template::create($page_template);
	$templater->register_page_templates();
	$templater->register('navclass', 			$navclass);
	$templater->register('HTML', 				$HTML);
	$templater->register('navbar', 				$navbar);
	$templater->register('pagetitle', 			$pagetitle);
	$templater->register('pagedescription', 	$pagedescription);
	$templater->register('template_hook', 		$template_hook);
	$templater->register('includecss', 			$includecss);
	$templater->register('year',				date('Y'));
	$templater->register('jQueryVersion',		VBDOWNLOADS::$jQueryVersion);
	$templater->register('jQueryPath',			VBDOWNLOADS::jQueryPath());
	$templater->register('jQueryUiThemePath',	VBDOWNLOADS::jQueryUiThemePath());
	$templater->register('version',				VBDOWNLOADS::$version);
	$templater->register('versionnumber', 		VBDOWNLOADS::$versionnumber);
	$templater->register('headinclude', 		$headinclude);
	$templater->register('stats', 				$stats);
	$templater->register('reportReasons', 		$reportReasons);
print_output($templater->render());